import { type NextRequest, NextResponse } from "next/server"
import { client, getUserById } from "@/lib/typesense"

export async function GET(request: NextRequest) {
  try {
    const searchResults = await client.collections("user_ads").documents().search({
      q: "*",
      per_page: 250,
    })

    const ads = []

    for (const hit of searchResults.hits || []) {
      const ad = hit.document

      // Get user details
      const user = await getUserById(ad.userId)

      ads.push({
        ...ad,
        username: user?.username || "Unknown User",
        walletBalance: user?.walletBalance || 0,
      })
    }

    return NextResponse.json({
      success: true,
      ads: ads,
      total: searchResults.found || 0,
    })
  } catch (error) {
    console.error("Error fetching user ads:", error)
    return NextResponse.json({
      success: false,
      error: "Failed to fetch user ads",
      ads: [],
    })
  }
}
