import { NextResponse } from "next/server"
import typesenseClient from "@/lib/typesense"

export async function GET() {
  try {
    console.log("[v0] Testing Typesense connection with config:", {
      host: process.env.TYPESENSE_HOST || process.env.NEXT_PUBLIC_TYPESENSE_HOST,
      port: process.env.TYPESENSE_PORT || process.env.NEXT_PUBLIC_TYPESENSE_PORT,
      protocol: process.env.TYPESENSE_PROTOCOL,
      hasApiKey: !!process.env.TYPESENSE_API_KEY,
    })

    const collections = await typesenseClient.collections().retrieve()
    console.log("[v0] Connection successful, collections:", collections)

    return NextResponse.json({
      success: true,
      message: "Connection successful",
      collections: collections.length,
      config: {
        host: process.env.TYPESENSE_HOST || process.env.NEXT_PUBLIC_TYPESENSE_HOST,
        port: process.env.TYPESENSE_PORT || process.env.NEXT_PUBLIC_TYPESENSE_PORT,
        protocol: process.env.TYPESENSE_PROTOCOL,
      },
    })
  } catch (error) {
    console.error("[v0] Connection test failed:", error)
    return NextResponse.json(
      {
        success: false,
        error: error instanceof Error ? error.message : "Connection failed",
        config: {
          host: process.env.TYPESENSE_HOST || process.env.NEXT_PUBLIC_TYPESENSE_HOST || "not set",
          port: process.env.TYPESENSE_PORT || process.env.NEXT_PUBLIC_TYPESENSE_PORT || "not set",
          protocol: process.env.TYPESENSE_PROTOCOL || "not set",
          hasApiKey: !!process.env.TYPESENSE_API_KEY,
        },
      },
      { status: 500 },
    )
  }
}
