import { NextResponse } from "next/server"
import typesenseClient from "@/lib/typesense"

export async function POST() {
  try {
    // Define collection schemas
    const webSchema = {
      name: "web_results",
      fields: [
        { name: "title", type: "string" },
        { name: "description", type: "string" },
        { name: "url", type: "string" },
        { name: "date", type: "string", optional: true },
        { name: "keywords", type: "string[]", optional: true },
        { name: "safesearch", type: "bool" },
        { name: "maindomain", type: "bool" },
        { name: "favicon", type: "string", optional: true },
      ],
    }

    const imageSchema = {
      name: "image_results",
      fields: [
        { name: "title", type: "string" },
        { name: "url", type: "string" },
        { name: "imgurl", type: "string" },
        { name: "keywords", type: "string[]", optional: true },
        { name: "date", type: "string", optional: true },
        { name: "safesearch", type: "bool" },
        { name: "favicon", type: "string", optional: true },
      ],
    }

    const results = []

    // Create web_results collection
    try {
      await typesenseClient.collections("web_results").delete()
    } catch (error) {
      // Collection doesn't exist, that's fine
    }

    try {
      await typesenseClient.collections().create(webSchema)
      results.push("web_results collection created")
    } catch (error) {
      results.push(`Failed to create web_results: ${error}`)
    }

    // Create image_results collection
    try {
      await typesenseClient.collections("image_results").delete()
    } catch (error) {
      // Collection doesn't exist, that's fine
    }

    try {
      await typesenseClient.collections().create(imageSchema)
      results.push("image_results collection created")
    } catch (error) {
      results.push(`Failed to create image_results: ${error}`)
    }

    return NextResponse.json({
      success: true,
      message: "Collections recreated successfully",
      results,
    })
  } catch (error) {
    console.error("Recreate collections error:", error)
    return NextResponse.json(
      {
        success: false,
        error: error instanceof Error ? error.message : "Unknown error",
      },
      { status: 500 },
    )
  }
}
