import { NextResponse } from "next/server"
import typesenseClient from "@/lib/typesense"

export async function GET() {
  try {
    const recentActivity = []

    try {
      // Get recent web results
      const webResults = await typesenseClient.collections("web_results").documents().search({
        q: "*",
        query_by: "title",
        sort_by: "date:desc",
        per_page: 5,
      })

      webResults.hits?.forEach((hit: any) => {
        recentActivity.push({
          id: hit.document.id,
          type: "web",
          title: hit.document.title,
          url: hit.document.url,
          date: hit.document.date || new Date().toISOString(),
          action: "added",
        })
      })
    } catch (error) {
      console.log("No web results collection found")
    }

    try {
      // Get recent image results
      const imageResults = await typesenseClient.collections("image_results").documents().search({
        q: "*",
        query_by: "title",
        sort_by: "date:desc",
        per_page: 5,
      })

      imageResults.hits?.forEach((hit: any) => {
        recentActivity.push({
          id: hit.document.id,
          type: "image",
          title: hit.document.title,
          url: hit.document.url,
          date: hit.document.date || new Date().toISOString(),
          action: "added",
        })
      })
    } catch (error) {
      console.log("No image results collection found")
    }

    // Sort by date and limit to 10 most recent
    recentActivity.sort((a, b) => new Date(b.date).getTime() - new Date(a.date).getTime())

    return NextResponse.json(recentActivity.slice(0, 10))
  } catch (error) {
    console.error("Error fetching recent activity:", error)
    return NextResponse.json({ error: "Failed to fetch recent activity" }, { status: 500 })
  }
}
