import { NextResponse } from "next/server"
import { cookies } from "next/headers"
import { getAdminById } from "@/lib/typesense"

export async function GET() {
  try {
    const cookieStore = cookies()
    const adminSession = cookieStore.get("admin_session")

    if (!adminSession) {
      return NextResponse.json({ message: "No admin session" }, { status: 401 })
    }

    const admin = await getAdminById(adminSession.value)

    if (!admin) {
      return NextResponse.json({ message: "Invalid admin session" }, { status: 401 })
    }

    return NextResponse.json({
      admin: {
        id: admin.id,
        username: admin.username,
        email: admin.email,
        createdAt: admin.createdAt,
        lastLoginAt: admin.lastLoginAt,
      },
    })
  } catch (error) {
    console.error("Admin validation error:", error)
    return NextResponse.json({ message: "Validation failed" }, { status: 500 })
  }
}
