import { type NextRequest, NextResponse } from "next/server"
import { cookies } from "next/headers"
import { updateAdminPassword } from "@/lib/typesense"

export async function POST(request: NextRequest) {
  try {
    const cookieStore = cookies()
    const adminSession = cookieStore.get("admin_session")

    if (!adminSession) {
      return NextResponse.json({ message: "Unauthorized" }, { status: 401 })
    }

    const { currentPassword, newPassword } = await request.json()

    if (!currentPassword || !newPassword) {
      return NextResponse.json({ message: "Current and new passwords are required" }, { status: 400 })
    }

    if (newPassword.length < 6) {
      return NextResponse.json({ message: "New password must be at least 6 characters long" }, { status: 400 })
    }

    const success = await updateAdminPassword(adminSession.value, currentPassword, newPassword)

    if (!success) {
      return NextResponse.json({ message: "Current password is incorrect" }, { status: 400 })
    }

    return NextResponse.json({ message: "Password updated successfully" })
  } catch (error) {
    console.error("Admin password update error:", error)
    return NextResponse.json({ message: "Password update failed" }, { status: 500 })
  }
}
