import { NextResponse } from "next/server"
import { cookies } from "next/headers"

export async function POST() {
  try {
    const cookieStore = cookies()
    cookieStore.delete("admin_session")

    return NextResponse.json({ message: "Logout successful" })
  } catch (error) {
    console.error("Admin logout error:", error)
    return NextResponse.json({ message: "Logout failed" }, { status: 500 })
  }
}
