import { NextResponse } from "next/server"

export async function GET() {
  try {
    const allowRegister = process.env.ALLOW_ADMIN_REGISTER === "true"

    return NextResponse.json({ allowRegister })
  } catch (error) {
    console.error("Error getting admin config:", error)
    return NextResponse.json({ allowRegister: false })
  }
}
