import { type NextRequest, NextResponse } from "next/server"
import typesenseClient from "@/lib/typesense"

export async function POST(request: NextRequest) {
  try {
    const { collection, document } = await request.json()

    if (!collection || !document) {
      return NextResponse.json(
        {
          success: false,
          error: "Collection and document are required",
        },
        { status: 400 },
      )
    }

    const result = await typesenseClient.collections(collection).documents().create(document)

    return NextResponse.json({
      success: true,
      message: "Document added successfully",
      document: result,
    })
  } catch (error) {
    console.error("Document creation error:", error)
    return NextResponse.json(
      {
        success: false,
        error: error instanceof Error ? error.message : "Unknown error",
      },
      { status: 500 },
    )
  }
}
