# IndusSearch - Typesense Data Management CURL Commands

## Prerequisites
Make sure your Typesense server is running and environment variables are set:
- TYPESENSE_HOST
- TYPESENSE_PORT  
- TYPESENSE_PROTOCOL
- TYPESENSE_API_KEY

## Bulk Data Seeding

### Seed All Data (Web + Images)
\`\`\`bash
curl -X POST http://localhost:3000/api/admin/seed-data \
  -H "Content-Type: application/json" \
  -d '{"type": "all"}'
\`\`\`

### Seed Web Results Only
\`\`\`bash
curl -X POST http://localhost:3000/api/admin/seed-data \
  -H "Content-Type: application/json" \
  -d '{"type": "web"}'
\`\`\`

### Seed Image Results Only
\`\`\`bash
curl -X POST http://localhost:3000/api/admin/seed-data \
  -H "Content-Type: application/json" \
  -d '{"type": "images"}'
\`\`\`

## Add Individual Documents

### Add Web Result
\`\`\`bash
curl -X POST http://localhost:3000/api/admin/add-web \
  -H "Content-Type: application/json" \
  -d '{
    "title": "Custom Website Title",
    "description": "Custom website description with detailed information about the site",
    "url": "https://example.com",
    "date": "2024-01-20",
    "keywords": ["custom", "example", "website", "demo"],
    "safesearch": true,
    "maindomain": true,
    "favicon": "https://www.google.com/s2/favicons?domain=example.com&sz=32"
  }'
\`\`\`

### Add Image Result
\`\`\`bash
curl -X POST http://localhost:3000/api/admin/add-image \
  -H "Content-Type: application/json" \
  -d '{
    "title": "Custom Image Title",
    "url": "https://example.com",
    "imgurl": "https://example.com/sample-image.jpg",
    "keywords": ["custom", "image", "example", "photo"],
    "date": "2024-01-20",
    "safesearch": true,
    "favicon": "https://www.google.com/s2/favicons?domain=example.com&sz=32"
  }'
\`\`\`

## Sample Data Examples

### Add Reddit Web Result
\`\`\`bash
curl -X POST http://localhost:3000/api/admin/add-web \
  -H "Content-Type: application/json" \
  -d '{
    "title": "Reddit - The Front Page of the Internet",
    "description": "Reddit is a network of communities where people can dive into their interests, hobbies and passions. There'\''s a community for whatever you'\''re interested in on Reddit.",
    "url": "https://www.reddit.com",
    "keywords": ["reddit", "community", "social", "discussion"],
    "safesearch": true,
    "maindomain": true
  }'
\`\`\`

### Add Wikipedia Web Result
\`\`\`bash
curl -X POST http://localhost:3000/api/admin/add-web \
  -H "Content-Type: application/json" \
  -d '{
    "title": "Wikipedia - The Free Encyclopedia",
    "description": "Wikipedia is a multilingual free online encyclopedia written and maintained by a community of volunteers through open collaboration and a wiki-based editing system.",
    "url": "https://www.wikipedia.org",
    "keywords": ["wikipedia", "encyclopedia", "knowledge", "education"],
    "safesearch": true,
    "maindomain": true
  }'
\`\`\`

### Add Apple Logo Image
\`\`\`bash
curl -X POST http://localhost:3000/api/admin/add-image \
  -H "Content-Type: application/json" \
  -d '{
    "title": "Apple Logo",
    "url": "https://www.apple.com",
    "imgurl": "https://upload.wikimedia.org/wikipedia/commons/f/fa/Apple_logo_black.svg",
    "keywords": ["apple", "logo", "brand", "technology"],
    "safesearch": true
  }'
\`\`\`

### Add Microsoft Logo Image
\`\`\`bash
curl -X POST http://localhost:3000/api/admin/add-image \
  -H "Content-Type: application/json" \
  -d '{
    "title": "Microsoft Logo",
    "url": "https://www.microsoft.com",
    "imgurl": "https://upload.wikimedia.org/wikipedia/commons/9/96/Microsoft_logo_%282012%29.svg",
    "keywords": ["microsoft", "logo", "brand", "software"],
    "safesearch": true
  }'
\`\`\`

## Sample Data Included

### Web Results (10 entries):
- Google - Search engine
- Facebook - Social network
- Instagram - Photo sharing
- YouTube - Video platform
- Twitter - Microblogging
- LinkedIn - Professional network
- Amazon - E-commerce
- Netflix - Streaming service
- GitHub - Code repository
- Stack Overflow - Developer Q&A

### Image Results (6 entries):
- Logos for Google, Facebook, Instagram, YouTube, Twitter, LinkedIn

## Usage Instructions

1. **Import Postman Collection**: Import the `postman-collection.json` file into Postman
2. **Set Base URL**: Update the `base_url` variable to your application URL
3. **Run Seed Command**: Execute "Seed All Data" to populate both collections
4. **Add Individual Items**: Use the dedicated `/add-web` and `/add-image` endpoints for single entries
5. **Test Search**: Go to your IndusSearch homepage and search for terms like "google", "social", "video", etc.

## API Response Format

### Success Response
\`\`\`json
{
  "success": true,
  "message": "Web result added successfully",
  "document": {
    "id": "generated_id_here",
    "title": "...",
    "description": "...",
    // ... other fields
  }
}
\`\`\`

### Error Response
\`\`\`json
{
  "success": false,
  "error": "Title, description, and URL are required"
}
\`\`\`

## Production Deployment

For production, replace `localhost:3000` with your actual domain:
\`\`\`bash
curl -X POST https://yourdomain.com/api/admin/seed-data \
  -H "Content-Type: application/json" \
  -d '{"type": "all"}'
\`\`\`

## Notes

- **Auto-generated IDs**: If you don't provide an `id`, the system will generate one automatically
- **Auto-generated Favicons**: If you don't provide a `favicon`, it will be auto-generated from the domain
- **Collection Creation**: Collections are created automatically if they don't exist
- **Validation**: Required fields are validated before insertion
- **Date Format**: Use YYYY-MM-DD format for dates
